<?php

namespace App\Http\Controllers\api;

// use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\api\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Http\Resources\User\UserResource;


class UserController extends ApiController
{
    public $user;
    public function __construct(User $user) {
        $this->user = $user;
    }

    public function register(Request $request) {

        if ($request->has('userType') && $request->input('userType') == 'customer') {
            // return $this->customer_register($request);
            // exit();
        }

        $this->request = $request;
        $this->setValidationRules(['name' => 'required', 'email' => 'required|email|unique:users', 'password' => 'required']);
        if ($this->isValidRequest()) {
            $this->response = ['success' => false, 'error' => $this->getErrors()];
            $this->statusCode = self::STATUS_CODE_200;
            return $this->sendResponse();
        }

        $user = new User();

        $already = User::where('email', $request->input('email'))->first();
        if($already) {
            $this->response = ['status' => false, 'error' => 'User with this email is already registered.'];
            $this->statusCode = self::STATUS_CODE_200;
            return $this->sendResponse();
        }
        
            $user->name =  $request->input('name');
            $user->name = str_replace('undefined', '', $user->name);
        
        
        $user->email = $request->input('email');
        $user->password = Hash::make($request->input('password'));

        if($user->save()){
            // $this->sendMail(array('name' => $request->input('firstName').' '. $request->input('middleName').' '.$request->input('lastName'), 'email' => $request->input('email')), $activationCode, $plainPassword);
            $this->statusCode = 201;
            $this->response = [
                'success' => true,
                'message' => 'Your account has been created succesfully'
            ];
            return $this->sendResponse();
        }
        $this->statusCode = 200;
        $this->response = ['success' => false, 'error' => 'Your account has not been created.'];
        return $this->sendResponse();
    }

    public function login(Request $request) {

        $this->request = $request;
        $this->setValidationRules(['email' => 'required|email', 'password' => 'required']);
        if ($this->isValidRequest()) {
            $this->response = ['success' => false, 'error' => $this->getErrors()];
            $this->statusCode = self::STATUS_CODE_200;
           return $this->sendResponse();
        }

        $user = User::where('email', $request->input('email'))->first();
        // if($user && $user->status !== User::ACTIVE_STATUS) {
        //     $this->response = ['status' => false, 'error' => 'Your account is inactive please contact your Administrator.'];
        //     $this->statusCode = self::STATUS_CODE_200;
        //     return $this->sendResponse();
        // }

        if($user && Hash::check($request->input('password'), $user->password)){
            return new UserResource($user);
        }
        $this->response = ['status' => false, 'error' => 'Username or Password invalid.'];
        $this->statusCode = self::STATUS_CODE_200;
        return $this->sendResponse();
    }
}
